package io.burkard.cdk.services.ses

sealed abstract class SuppressionReasons(val underlying: software.amazon.awscdk.services.ses.SuppressionReasons)
  extends Product
    with Serializable

object SuppressionReasons {
  implicit def toAws(value: SuppressionReasons): software.amazon.awscdk.services.ses.SuppressionReasons =
    Option(value).map(_.underlying).orNull

  case object BouncesAndComplaints
    extends SuppressionReasons(software.amazon.awscdk.services.ses.SuppressionReasons.BOUNCES_AND_COMPLAINTS)

  case object BouncesOnly
    extends SuppressionReasons(software.amazon.awscdk.services.ses.SuppressionReasons.BOUNCES_ONLY)

  case object ComplaintsOnly
    extends SuppressionReasons(software.amazon.awscdk.services.ses.SuppressionReasons.COMPLAINTS_ONLY)
}
