package io.burkard.cdk.services.ses

sealed abstract class MailFromBehaviorOnMxFailure(val underlying: software.amazon.awscdk.services.ses.MailFromBehaviorOnMxFailure)
  extends Product
    with Serializable

object MailFromBehaviorOnMxFailure {
  implicit def toAws(value: MailFromBehaviorOnMxFailure): software.amazon.awscdk.services.ses.MailFromBehaviorOnMxFailure =
    Option(value).map(_.underlying).orNull

  case object UseDefaultValue
    extends MailFromBehaviorOnMxFailure(software.amazon.awscdk.services.ses.MailFromBehaviorOnMxFailure.USE_DEFAULT_VALUE)

  case object RejectMessage
    extends MailFromBehaviorOnMxFailure(software.amazon.awscdk.services.ses.MailFromBehaviorOnMxFailure.REJECT_MESSAGE)
}
