package io.burkard.cdk.services.ses

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EmailIdentityProps {

  def apply(
    identity: software.amazon.awscdk.services.ses.Identity,
    feedbackForwarding: Option[Boolean] = None,
    mailFromBehaviorOnMxFailure: Option[software.amazon.awscdk.services.ses.MailFromBehaviorOnMxFailure] = None,
    mailFromDomain: Option[String] = None,
    configurationSet: Option[software.amazon.awscdk.services.ses.IConfigurationSet] = None,
    dkimIdentity: Option[software.amazon.awscdk.services.ses.DkimIdentity] = None,
    dkimSigning: Option[Boolean] = None
  ): software.amazon.awscdk.services.ses.EmailIdentityProps =
    (new software.amazon.awscdk.services.ses.EmailIdentityProps.Builder)
      .identity(identity)
      .feedbackForwarding(feedbackForwarding.map(Boolean.box).orNull)
      .mailFromBehaviorOnMxFailure(mailFromBehaviorOnMxFailure.orNull)
      .mailFromDomain(mailFromDomain.orNull)
      .configurationSet(configurationSet.orNull)
      .dkimIdentity(dkimIdentity.orNull)
      .dkimSigning(dkimSigning.map(Boolean.box).orNull)
      .build()
}
