package io.burkard.cdk.services.ses

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object DkimIdentityConfig {

  def apply(
    domainSigningPrivateKey: Option[String] = None,
    domainSigningSelector: Option[String] = None,
    nextSigningKeyLength: Option[software.amazon.awscdk.services.ses.EasyDkimSigningKeyLength] = None
  ): software.amazon.awscdk.services.ses.DkimIdentityConfig =
    (new software.amazon.awscdk.services.ses.DkimIdentityConfig.Builder)
      .domainSigningPrivateKey(domainSigningPrivateKey.orNull)
      .domainSigningSelector(domainSigningSelector.orNull)
      .nextSigningKeyLength(nextSigningKeyLength.orNull)
      .build()
}
