package io.burkard.cdk.services.ses

sealed abstract class ConfigurationSetTlsPolicy(val underlying: software.amazon.awscdk.services.ses.ConfigurationSetTlsPolicy)
  extends Product
    with Serializable

object ConfigurationSetTlsPolicy {
  implicit def toAws(value: ConfigurationSetTlsPolicy): software.amazon.awscdk.services.ses.ConfigurationSetTlsPolicy =
    Option(value).map(_.underlying).orNull

  case object Require
    extends ConfigurationSetTlsPolicy(software.amazon.awscdk.services.ses.ConfigurationSetTlsPolicy.REQUIRE)

  case object Optional
    extends ConfigurationSetTlsPolicy(software.amazon.awscdk.services.ses.ConfigurationSetTlsPolicy.OPTIONAL)
}
