package io.burkard.cdk.services.ses

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ConfigurationSetProps {

  def apply(
    reputationMetrics: Option[Boolean] = None,
    customTrackingRedirectDomain: Option[String] = None,
    dedicatedIpPool: Option[software.amazon.awscdk.services.ses.IDedicatedIpPool] = None,
    suppressionReasons: Option[software.amazon.awscdk.services.ses.SuppressionReasons] = None,
    configurationSetName: Option[String] = None,
    sendingEnabled: Option[Boolean] = None,
    tlsPolicy: Option[software.amazon.awscdk.services.ses.ConfigurationSetTlsPolicy] = None
  ): software.amazon.awscdk.services.ses.ConfigurationSetProps =
    (new software.amazon.awscdk.services.ses.ConfigurationSetProps.Builder)
      .reputationMetrics(reputationMetrics.map(Boolean.box).orNull)
      .customTrackingRedirectDomain(customTrackingRedirectDomain.orNull)
      .dedicatedIpPool(dedicatedIpPool.orNull)
      .suppressionReasons(suppressionReasons.orNull)
      .configurationSetName(configurationSetName.orNull)
      .sendingEnabled(sendingEnabled.map(Boolean.box).orNull)
      .tlsPolicy(tlsPolicy.orNull)
      .build()
}
