package io.burkard.cdk.services.ses

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ConfigurationSet {

  def apply(
    internalResourceId: String,
    reputationMetrics: Option[Boolean] = None,
    customTrackingRedirectDomain: Option[String] = None,
    dedicatedIpPool: Option[software.amazon.awscdk.services.ses.IDedicatedIpPool] = None,
    suppressionReasons: Option[software.amazon.awscdk.services.ses.SuppressionReasons] = None,
    configurationSetName: Option[String] = None,
    sendingEnabled: Option[Boolean] = None,
    tlsPolicy: Option[software.amazon.awscdk.services.ses.ConfigurationSetTlsPolicy] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ses.ConfigurationSet =
    software.amazon.awscdk.services.ses.ConfigurationSet.Builder
      .create(stackCtx, internalResourceId)
      .reputationMetrics(reputationMetrics.map(Boolean.box).orNull)
      .customTrackingRedirectDomain(customTrackingRedirectDomain.orNull)
      .dedicatedIpPool(dedicatedIpPool.orNull)
      .suppressionReasons(suppressionReasons.orNull)
      .configurationSetName(configurationSetName.orNull)
      .sendingEnabled(sendingEnabled.map(Boolean.box).orNull)
      .tlsPolicy(tlsPolicy.orNull)
      .build()
}
