package io.burkard.cdk.services.ses

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnEmailIdentityProps {

  def apply(
    emailIdentity: String,
    configurationSetAttributes: Option[software.amazon.awscdk.services.ses.CfnEmailIdentity.ConfigurationSetAttributesProperty] = None,
    dkimAttributes: Option[software.amazon.awscdk.services.ses.CfnEmailIdentity.DkimAttributesProperty] = None,
    mailFromAttributes: Option[software.amazon.awscdk.services.ses.CfnEmailIdentity.MailFromAttributesProperty] = None,
    dkimSigningAttributes: Option[software.amazon.awscdk.services.ses.CfnEmailIdentity.DkimSigningAttributesProperty] = None,
    feedbackAttributes: Option[software.amazon.awscdk.services.ses.CfnEmailIdentity.FeedbackAttributesProperty] = None
  ): software.amazon.awscdk.services.ses.CfnEmailIdentityProps =
    (new software.amazon.awscdk.services.ses.CfnEmailIdentityProps.Builder)
      .emailIdentity(emailIdentity)
      .configurationSetAttributes(configurationSetAttributes.orNull)
      .dkimAttributes(dkimAttributes.orNull)
      .mailFromAttributes(mailFromAttributes.orNull)
      .dkimSigningAttributes(dkimSigningAttributes.orNull)
      .feedbackAttributes(feedbackAttributes.orNull)
      .build()
}
