package io.burkard.cdk.services.servicecatalog

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ProductStackHistoryProps {

  def apply(
    currentVersionLocked: Boolean,
    currentVersionName: String,
    productStack: software.amazon.awscdk.services.servicecatalog.ProductStack,
    description: Option[String] = None,
    validateTemplate: Option[Boolean] = None,
    directory: Option[String] = None
  ): software.amazon.awscdk.services.servicecatalog.ProductStackHistoryProps =
    (new software.amazon.awscdk.services.servicecatalog.ProductStackHistoryProps.Builder)
      .currentVersionLocked(currentVersionLocked)
      .currentVersionName(currentVersionName)
      .productStack(productStack)
      .description(description.orNull)
      .validateTemplate(validateTemplate.map(Boolean.box).orNull)
      .directory(directory.orNull)
      .build()
}
