package io.burkard.cdk.services.servicecatalog

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ProductStackHistory {

  def apply(
    internalResourceId: String,
    currentVersionLocked: Boolean,
    currentVersionName: String,
    productStack: software.amazon.awscdk.services.servicecatalog.ProductStack,
    description: Option[String] = None,
    validateTemplate: Option[Boolean] = None,
    directory: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.servicecatalog.ProductStackHistory =
    software.amazon.awscdk.services.servicecatalog.ProductStackHistory.Builder
      .create(stackCtx, internalResourceId)
      .currentVersionLocked(currentVersionLocked)
      .currentVersionName(currentVersionName)
      .productStack(productStack)
      .description(description.orNull)
      .validateTemplate(validateTemplate.map(Boolean.box).orNull)
      .directory(directory.orNull)
      .build()
}
