package io.burkard.cdk.services.servicecatalog

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object PortfolioProps {

  def apply(
    displayName: String,
    providerName: String,
    messageLanguage: Option[software.amazon.awscdk.services.servicecatalog.MessageLanguage] = None,
    description: Option[String] = None,
    tagOptions: Option[software.amazon.awscdk.services.servicecatalog.TagOptions] = None
  ): software.amazon.awscdk.services.servicecatalog.PortfolioProps =
    (new software.amazon.awscdk.services.servicecatalog.PortfolioProps.Builder)
      .displayName(displayName)
      .providerName(providerName)
      .messageLanguage(messageLanguage.orNull)
      .description(description.orNull)
      .tagOptions(tagOptions.orNull)
      .build()
}
