package io.burkard.cdk.services.servicecatalog

sealed abstract class MessageLanguage(val underlying: software.amazon.awscdk.services.servicecatalog.MessageLanguage)
  extends Product
    with Serializable

object MessageLanguage {
  implicit def toAws(value: MessageLanguage): software.amazon.awscdk.services.servicecatalog.MessageLanguage =
    Option(value).map(_.underlying).orNull

  case object En
    extends MessageLanguage(software.amazon.awscdk.services.servicecatalog.MessageLanguage.EN)

  case object Jp
    extends MessageLanguage(software.amazon.awscdk.services.servicecatalog.MessageLanguage.JP)

  case object Zh
    extends MessageLanguage(software.amazon.awscdk.services.servicecatalog.MessageLanguage.ZH)
}
