package io.burkard.cdk.services.servicecatalog

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CloudFormationRuleConstraintOptions {

  def apply(
    rule: software.amazon.awscdk.services.servicecatalog.TemplateRule,
    description: Option[String] = None,
    messageLanguage: Option[software.amazon.awscdk.services.servicecatalog.MessageLanguage] = None
  ): software.amazon.awscdk.services.servicecatalog.CloudFormationRuleConstraintOptions =
    (new software.amazon.awscdk.services.servicecatalog.CloudFormationRuleConstraintOptions.Builder)
      .rule(rule)
      .description(description.orNull)
      .messageLanguage(messageLanguage.orNull)
      .build()
}
