package io.burkard.cdk.services.servicecatalog

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPortfolioShareProps {

  def apply(
    accountId: String,
    portfolioId: String,
    shareTagOptions: Option[Boolean] = None,
    acceptLanguage: Option[String] = None
  ): software.amazon.awscdk.services.servicecatalog.CfnPortfolioShareProps =
    (new software.amazon.awscdk.services.servicecatalog.CfnPortfolioShareProps.Builder)
      .accountId(accountId)
      .portfolioId(portfolioId)
      .shareTagOptions(shareTagOptions.map(Boolean.box).orNull)
      .acceptLanguage(acceptLanguage.orNull)
      .build()
}
