package io.burkard.cdk.services.secretsmanager.cfnRotationSchedule

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object HostedRotationLambdaProperty {

  def apply(
    rotationType: String,
    vpcSecurityGroupIds: Option[String] = None,
    masterSecretArn: Option[String] = None,
    excludeCharacters: Option[String] = None,
    rotationLambdaName: Option[String] = None,
    superuserSecretArn: Option[String] = None,
    vpcSubnetIds: Option[String] = None,
    kmsKeyArn: Option[String] = None,
    masterSecretKmsKeyArn: Option[String] = None,
    superuserSecretKmsKeyArn: Option[String] = None
  ): software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule.HostedRotationLambdaProperty =
    (new software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule.HostedRotationLambdaProperty.Builder)
      .rotationType(rotationType)
      .vpcSecurityGroupIds(vpcSecurityGroupIds.orNull)
      .masterSecretArn(masterSecretArn.orNull)
      .excludeCharacters(excludeCharacters.orNull)
      .rotationLambdaName(rotationLambdaName.orNull)
      .superuserSecretArn(superuserSecretArn.orNull)
      .vpcSubnetIds(vpcSubnetIds.orNull)
      .kmsKeyArn(kmsKeyArn.orNull)
      .masterSecretKmsKeyArn(masterSecretKmsKeyArn.orNull)
      .superuserSecretKmsKeyArn(superuserSecretKmsKeyArn.orNull)
      .build()
}
