package io.burkard.cdk.services.sagemaker.cfnDomain

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object RStudioServerProDomainSettingsProperty {

  def apply(
    domainExecutionRoleArn: String,
    rStudioConnectUrl: Option[String] = None,
    rStudioPackageManagerUrl: Option[String] = None,
    defaultResourceSpec: Option[software.amazon.awscdk.services.sagemaker.CfnDomain.ResourceSpecProperty] = None
  ): software.amazon.awscdk.services.sagemaker.CfnDomain.RStudioServerProDomainSettingsProperty =
    (new software.amazon.awscdk.services.sagemaker.CfnDomain.RStudioServerProDomainSettingsProperty.Builder)
      .domainExecutionRoleArn(domainExecutionRoleArn)
      .rStudioConnectUrl(rStudioConnectUrl.orNull)
      .rStudioPackageManagerUrl(rStudioPackageManagerUrl.orNull)
      .defaultResourceSpec(defaultResourceSpec.orNull)
      .build()
}
