package io.burkard.cdk.services.s3

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BlockPublicAccessOptions {

  def apply(
    blockPublicAcls: Option[Boolean] = None,
    blockPublicPolicy: Option[Boolean] = None,
    ignorePublicAcls: Option[Boolean] = None,
    restrictPublicBuckets: Option[Boolean] = None
  ): software.amazon.awscdk.services.s3.BlockPublicAccessOptions =
    (new software.amazon.awscdk.services.s3.BlockPublicAccessOptions.Builder)
      .blockPublicAcls(blockPublicAcls.map(Boolean.box).orNull)
      .blockPublicPolicy(blockPublicPolicy.map(Boolean.box).orNull)
      .ignorePublicAcls(ignorePublicAcls.map(Boolean.box).orNull)
      .restrictPublicBuckets(restrictPublicBuckets.map(Boolean.box).orNull)
      .build()
}
