package io.burkard.cdk.services.route53.cfnRecordSetGroup

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object RecordSetProperty {

  def apply(
    name: String,
    `type`: String,
    geoLocation: Option[software.amazon.awscdk.services.route53.CfnRecordSetGroup.GeoLocationProperty] = None,
    weight: Option[Number] = None,
    healthCheckId: Option[String] = None,
    aliasTarget: Option[software.amazon.awscdk.services.route53.CfnRecordSetGroup.AliasTargetProperty] = None,
    hostedZoneId: Option[String] = None,
    setIdentifier: Option[String] = None,
    multiValueAnswer: Option[Boolean] = None,
    hostedZoneName: Option[String] = None,
    cidrRoutingConfig: Option[software.amazon.awscdk.services.route53.CfnRecordSetGroup.CidrRoutingConfigProperty] = None,
    resourceRecords: Option[List[String]] = None,
    region: Option[String] = None,
    ttl: Option[String] = None,
    failover: Option[String] = None
  ): software.amazon.awscdk.services.route53.CfnRecordSetGroup.RecordSetProperty =
    (new software.amazon.awscdk.services.route53.CfnRecordSetGroup.RecordSetProperty.Builder)
      .name(name)
      .`type`(`type`)
      .geoLocation(geoLocation.orNull)
      .weight(weight.orNull)
      .healthCheckId(healthCheckId.orNull)
      .aliasTarget(aliasTarget.orNull)
      .hostedZoneId(hostedZoneId.orNull)
      .setIdentifier(setIdentifier.orNull)
      .multiValueAnswer(multiValueAnswer.map(Boolean.box).orNull)
      .hostedZoneName(hostedZoneName.orNull)
      .cidrRoutingConfig(cidrRoutingConfig.orNull)
      .resourceRecords(resourceRecords.map(_.asJava).orNull)
      .region(region.orNull)
      .ttl(ttl.orNull)
      .failover(failover.orNull)
      .build()
}
