package io.burkard.cdk.services.route53

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CnameRecord {

  def apply(
    internalResourceId: String,
    domainName: String,
    recordName: Option[String] = None,
    comment: Option[String] = None,
    ttl: Option[software.amazon.awscdk.Duration] = None,
    deleteExisting: Option[Boolean] = None,
    zone: Option[software.amazon.awscdk.services.route53.IHostedZone] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.route53.CnameRecord =
    software.amazon.awscdk.services.route53.CnameRecord.Builder
      .create(stackCtx, internalResourceId)
      .domainName(domainName)
      .recordName(recordName.orNull)
      .comment(comment.orNull)
      .ttl(ttl.orNull)
      .deleteExisting(deleteExisting.map(Boolean.box).orNull)
      .zone(zone.orNull)
      .build()
}
