package io.burkard.cdk.services.resiliencehub

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnApp {

  def apply(
    internalResourceId: String,
    name: String,
    resourceMappings: List[_],
    appTemplateBody: String,
    resiliencyPolicyArn: Option[String] = None,
    appAssessmentSchedule: Option[String] = None,
    description: Option[String] = None,
    tags: Option[Map[String, String]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.resiliencehub.CfnApp =
    software.amazon.awscdk.services.resiliencehub.CfnApp.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .resourceMappings(resourceMappings.asJava)
      .appTemplateBody(appTemplateBody)
      .resiliencyPolicyArn(resiliencyPolicyArn.orNull)
      .appAssessmentSchedule(appAssessmentSchedule.orNull)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
