package io.burkard.cdk.services.rekognition

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnCollection {

  def apply(
    internalResourceId: String,
    collectionId: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.rekognition.CfnCollection =
    software.amazon.awscdk.services.rekognition.CfnCollection.Builder
      .create(stackCtx, internalResourceId)
      .collectionId(collectionId)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
