package io.burkard.cdk.services.rds

sealed abstract class InstanceUpdateBehaviour(val underlying: software.amazon.awscdk.services.rds.InstanceUpdateBehaviour)
  extends Product
    with Serializable

object InstanceUpdateBehaviour {
  implicit def toAws(value: InstanceUpdateBehaviour): software.amazon.awscdk.services.rds.InstanceUpdateBehaviour =
    Option(value).map(_.underlying).orNull

  case object Bulk
    extends InstanceUpdateBehaviour(software.amazon.awscdk.services.rds.InstanceUpdateBehaviour.BULK)

  case object Rolling
    extends InstanceUpdateBehaviour(software.amazon.awscdk.services.rds.InstanceUpdateBehaviour.ROLLING)
}
