package io.burkard.cdk.services.pinpointemail

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnIdentityProps {

  def apply(
    name: String,
    feedbackForwardingEnabled: Option[Boolean] = None,
    dkimSigningEnabled: Option[Boolean] = None,
    mailFromAttributes: Option[software.amazon.awscdk.services.pinpointemail.CfnIdentity.MailFromAttributesProperty] = None,
    tags: Option[List[_ <: software.amazon.awscdk.services.pinpointemail.CfnIdentity.TagsProperty]] = None
  ): software.amazon.awscdk.services.pinpointemail.CfnIdentityProps =
    (new software.amazon.awscdk.services.pinpointemail.CfnIdentityProps.Builder)
      .name(name)
      .feedbackForwardingEnabled(feedbackForwardingEnabled.map(Boolean.box).orNull)
      .dkimSigningEnabled(dkimSigningEnabled.map(Boolean.box).orNull)
      .mailFromAttributes(mailFromAttributes.orNull)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
