package io.burkard.cdk.services.networkmanager

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnCustomerGatewayAssociationProps {

  def apply(
    customerGatewayArn: String,
    globalNetworkId: String,
    deviceId: String,
    linkId: Option[String] = None
  ): software.amazon.awscdk.services.networkmanager.CfnCustomerGatewayAssociationProps =
    (new software.amazon.awscdk.services.networkmanager.CfnCustomerGatewayAssociationProps.Builder)
      .customerGatewayArn(customerGatewayArn)
      .globalNetworkId(globalNetworkId)
      .deviceId(deviceId)
      .linkId(linkId.orNull)
      .build()
}
