package io.burkard.cdk.services.networkmanager

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnConnectPeer {

  def apply(
    internalResourceId: String,
    insideCidrBlocks: Option[List[String]] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    connectAttachmentId: Option[String] = None,
    coreNetworkAddress: Option[String] = None,
    bgpOptions: Option[software.amazon.awscdk.services.networkmanager.CfnConnectPeer.BgpOptionsProperty] = None,
    peerAddress: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.networkmanager.CfnConnectPeer =
    software.amazon.awscdk.services.networkmanager.CfnConnectPeer.Builder
      .create(stackCtx, internalResourceId)
      .insideCidrBlocks(insideCidrBlocks.map(_.asJava).orNull)
      .tags(tags.map(_.asJava).orNull)
      .connectAttachmentId(connectAttachmentId.orNull)
      .coreNetworkAddress(coreNetworkAddress.orNull)
      .bgpOptions(bgpOptions.orNull)
      .peerAddress(peerAddress.orNull)
      .build()
}
