package io.burkard.cdk.services.msk

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnBatchScramSecret {

  def apply(
    internalResourceId: String,
    clusterArn: String,
    secretArnList: Option[List[String]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.msk.CfnBatchScramSecret =
    software.amazon.awscdk.services.msk.CfnBatchScramSecret.Builder
      .create(stackCtx, internalResourceId)
      .clusterArn(clusterArn)
      .secretArnList(secretArnList.map(_.asJava).orNull)
      .build()
}
