package io.burkard.cdk.services.logs.cfnMetricFilter

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object MetricTransformationProperty {

  def apply(
    metricName: String,
    metricNamespace: String,
    metricValue: String,
    dimensions: Option[List[_]] = None,
    unit: Option[String] = None,
    defaultValue: Option[Number] = None
  ): software.amazon.awscdk.services.logs.CfnMetricFilter.MetricTransformationProperty =
    (new software.amazon.awscdk.services.logs.CfnMetricFilter.MetricTransformationProperty.Builder)
      .metricName(metricName)
      .metricNamespace(metricNamespace)
      .metricValue(metricValue)
      .dimensions(dimensions.map(_.asJava).orNull)
      .unit(unit.orNull)
      .defaultValue(defaultValue.orNull)
      .build()
}
