package io.burkard.cdk.services.logs

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object QueryDefinitionProps {

  def apply(
    queryDefinitionName: String,
    queryString: software.amazon.awscdk.services.logs.QueryString,
    logGroups: Option[List[_ <: software.amazon.awscdk.services.logs.ILogGroup]] = None
  ): software.amazon.awscdk.services.logs.QueryDefinitionProps =
    (new software.amazon.awscdk.services.logs.QueryDefinitionProps.Builder)
      .queryDefinitionName(queryDefinitionName)
      .queryString(queryString)
      .logGroups(logGroups.map(_.asJava).orNull)
      .build()
}
