package io.burkard.cdk.services.lightsail.cfnDistribution

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CacheSettingsProperty {

  def apply(
    cachedHttpMethods: Option[String] = None,
    forwardedQueryStrings: Option[software.amazon.awscdk.services.lightsail.CfnDistribution.QueryStringObjectProperty] = None,
    defaultTtl: Option[Number] = None,
    minimumTtl: Option[Number] = None,
    allowedHttpMethods: Option[String] = None,
    forwardedCookies: Option[software.amazon.awscdk.services.lightsail.CfnDistribution.CookieObjectProperty] = None,
    forwardedHeaders: Option[software.amazon.awscdk.services.lightsail.CfnDistribution.HeaderObjectProperty] = None,
    maximumTtl: Option[Number] = None
  ): software.amazon.awscdk.services.lightsail.CfnDistribution.CacheSettingsProperty =
    (new software.amazon.awscdk.services.lightsail.CfnDistribution.CacheSettingsProperty.Builder)
      .cachedHttpMethods(cachedHttpMethods.orNull)
      .forwardedQueryStrings(forwardedQueryStrings.orNull)
      .defaultTtl(defaultTtl.orNull)
      .minimumTtl(minimumTtl.orNull)
      .allowedHttpMethods(allowedHttpMethods.orNull)
      .forwardedCookies(forwardedCookies.orNull)
      .forwardedHeaders(forwardedHeaders.orNull)
      .maximumTtl(maximumTtl.orNull)
      .build()
}
