package io.burkard.cdk.services.lightsail

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnLoadBalancer {

  def apply(
    internalResourceId: String,
    instancePort: Number,
    loadBalancerName: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    sessionStickinessEnabled: Option[Boolean] = None,
    healthCheckPath: Option[String] = None,
    sessionStickinessLbCookieDurationSeconds: Option[String] = None,
    ipAddressType: Option[String] = None,
    attachedInstances: Option[List[String]] = None,
    tlsPolicyName: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.lightsail.CfnLoadBalancer =
    software.amazon.awscdk.services.lightsail.CfnLoadBalancer.Builder
      .create(stackCtx, internalResourceId)
      .instancePort(instancePort)
      .loadBalancerName(loadBalancerName)
      .tags(tags.map(_.asJava).orNull)
      .sessionStickinessEnabled(sessionStickinessEnabled.map(Boolean.box).orNull)
      .healthCheckPath(healthCheckPath.orNull)
      .sessionStickinessLbCookieDurationSeconds(sessionStickinessLbCookieDurationSeconds.orNull)
      .ipAddressType(ipAddressType.orNull)
      .attachedInstances(attachedInstances.map(_.asJava).orNull)
      .tlsPolicyName(tlsPolicyName.orNull)
      .build()
}
