package io.burkard.cdk.services.lambda

sealed abstract class HttpMethod(val underlying: software.amazon.awscdk.services.lambda.HttpMethod)
  extends Product
    with Serializable

object HttpMethod {
  implicit def toAws(value: HttpMethod): software.amazon.awscdk.services.lambda.HttpMethod =
    Option(value).map(_.underlying).orNull

  case object Get
    extends HttpMethod(software.amazon.awscdk.services.lambda.HttpMethod.GET)

  case object Put
    extends HttpMethod(software.amazon.awscdk.services.lambda.HttpMethod.PUT)

  case object Head
    extends HttpMethod(software.amazon.awscdk.services.lambda.HttpMethod.HEAD)

  case object Post
    extends HttpMethod(software.amazon.awscdk.services.lambda.HttpMethod.POST)

  case object Delete
    extends HttpMethod(software.amazon.awscdk.services.lambda.HttpMethod.DELETE)

  case object Patch
    extends HttpMethod(software.amazon.awscdk.services.lambda.HttpMethod.PATCH)

  case object Options
    extends HttpMethod(software.amazon.awscdk.services.lambda.HttpMethod.OPTIONS)

  case object All
    extends HttpMethod(software.amazon.awscdk.services.lambda.HttpMethod.ALL)
}
