package io.burkard.cdk.services.lambda

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object FunctionUrlCorsOptions {

  def apply(
    allowedMethods: Option[List[_ <: software.amazon.awscdk.services.lambda.HttpMethod]] = None,
    exposedHeaders: Option[List[String]] = None,
    allowCredentials: Option[Boolean] = None,
    allowedHeaders: Option[List[String]] = None,
    maxAge: Option[software.amazon.awscdk.Duration] = None,
    allowedOrigins: Option[List[String]] = None
  ): software.amazon.awscdk.services.lambda.FunctionUrlCorsOptions =
    (new software.amazon.awscdk.services.lambda.FunctionUrlCorsOptions.Builder)
      .allowedMethods(allowedMethods.map(_.asJava).orNull)
      .exposedHeaders(exposedHeaders.map(_.asJava).orNull)
      .allowCredentials(allowCredentials.map(Boolean.box).orNull)
      .allowedHeaders(allowedHeaders.map(_.asJava).orNull)
      .maxAge(maxAge.orNull)
      .allowedOrigins(allowedOrigins.map(_.asJava).orNull)
      .build()
}
