package io.burkard.cdk.services.lambda

sealed abstract class FunctionUrlAuthType(val underlying: software.amazon.awscdk.services.lambda.FunctionUrlAuthType)
  extends Product
    with Serializable

object FunctionUrlAuthType {
  implicit def toAws(value: FunctionUrlAuthType): software.amazon.awscdk.services.lambda.FunctionUrlAuthType =
    Option(value).map(_.underlying).orNull

  case object AwsIam
    extends FunctionUrlAuthType(software.amazon.awscdk.services.lambda.FunctionUrlAuthType.AWS_IAM)

  case object None
    extends FunctionUrlAuthType(software.amazon.awscdk.services.lambda.FunctionUrlAuthType.NONE)
}
