package io.burkard.cdk.services.lambda

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object FunctionUrl {

  def apply(
    internalResourceId: String,
    function: software.amazon.awscdk.services.lambda.IFunction,
    authType: Option[software.amazon.awscdk.services.lambda.FunctionUrlAuthType] = None,
    cors: Option[software.amazon.awscdk.services.lambda.FunctionUrlCorsOptions] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.lambda.FunctionUrl =
    software.amazon.awscdk.services.lambda.FunctionUrl.Builder
      .create(stackCtx, internalResourceId)
      .function(function)
      .authType(authType.orNull)
      .cors(cors.orNull)
      .build()
}
