package io.burkard.cdk.services.lakeformation.cfnPrincipalPermissions

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object TableWithColumnsResourceProperty {

  def apply(
    name: String,
    catalogId: String,
    databaseName: String,
    columnWildcard: Option[software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissions.ColumnWildcardProperty] = None,
    columnNames: Option[List[String]] = None
  ): software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissions.TableWithColumnsResourceProperty =
    (new software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissions.TableWithColumnsResourceProperty.Builder)
      .name(name)
      .catalogId(catalogId)
      .databaseName(databaseName)
      .columnWildcard(columnWildcard.orNull)
      .columnNames(columnNames.map(_.asJava).orNull)
      .build()
}
