package io.burkard.cdk.services.lakeformation

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnTagAssociation {

  def apply(
    internalResourceId: String,
    resource: software.amazon.awscdk.services.lakeformation.CfnTagAssociation.ResourceProperty,
    lfTags: List[_]
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.lakeformation.CfnTagAssociation =
    software.amazon.awscdk.services.lakeformation.CfnTagAssociation.Builder
      .create(stackCtx, internalResourceId)
      .resource(resource)
      .lfTags(lfTags.asJava)
      .build()
}
