package io.burkard.cdk.services.kinesisanalyticsv2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnApplicationProps {

  def apply(
    serviceExecutionRole: String,
    runtimeEnvironment: String,
    applicationMaintenanceConfiguration: Option[software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.ApplicationMaintenanceConfigurationProperty] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    applicationName: Option[String] = None,
    applicationConfiguration: Option[software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.ApplicationConfigurationProperty] = None,
    applicationMode: Option[String] = None,
    runConfiguration: Option[software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.RunConfigurationProperty] = None,
    applicationDescription: Option[String] = None
  ): software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplicationProps =
    (new software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplicationProps.Builder)
      .serviceExecutionRole(serviceExecutionRole)
      .runtimeEnvironment(runtimeEnvironment)
      .applicationMaintenanceConfiguration(applicationMaintenanceConfiguration.orNull)
      .tags(tags.map(_.asJava).orNull)
      .applicationName(applicationName.orNull)
      .applicationConfiguration(applicationConfiguration.orNull)
      .applicationMode(applicationMode.orNull)
      .runConfiguration(runConfiguration.orNull)
      .applicationDescription(applicationDescription.orNull)
      .build()
}
