package io.burkard.cdk.services.kinesisanalytics.cfnApplicationV2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object S3ContentLocationProperty {

  def apply(
    fileKey: String,
    bucketArn: String,
    objectVersion: Option[String] = None
  ): software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.S3ContentLocationProperty =
    (new software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.S3ContentLocationProperty.Builder)
      .fileKey(fileKey)
      .bucketArn(bucketArn)
      .objectVersion(objectVersion.orNull)
      .build()
}
