package io.burkard.cdk.services.kinesisanalytics.cfnApplicationReferenceDataSourceV2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ReferenceDataSourceProperty {

  def apply(
    referenceSchema: software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSourceV2.ReferenceSchemaProperty,
    tableName: Option[String] = None,
    s3ReferenceDataSource: Option[software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSourceV2.S3ReferenceDataSourceProperty] = None
  ): software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSourceV2.ReferenceDataSourceProperty =
    (new software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSourceV2.ReferenceDataSourceProperty.Builder)
      .referenceSchema(referenceSchema)
      .tableName(tableName.orNull)
      .s3ReferenceDataSource(s3ReferenceDataSource.orNull)
      .build()
}
