package io.burkard.cdk.services.kinesis

sealed abstract class StreamMode(val underlying: software.amazon.awscdk.services.kinesis.StreamMode)
  extends Product
    with Serializable

object StreamMode {
  implicit def toAws(value: StreamMode): software.amazon.awscdk.services.kinesis.StreamMode =
    Option(value).map(_.underlying).orNull

  case object Provisioned
    extends StreamMode(software.amazon.awscdk.services.kinesis.StreamMode.PROVISIONED)

  case object OnDemand
    extends StreamMode(software.amazon.awscdk.services.kinesis.StreamMode.ON_DEMAND)
}
