package io.burkard.cdk.services.iottwinmaker.cfnComponentType

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object PropertyDefinitionProperty {

  def apply(
    isTimeSeries: Option[Boolean] = None,
    isStoredExternally: Option[Boolean] = None,
    isExternalId: Option[Boolean] = None,
    isRequiredInEntity: Option[Boolean] = None,
    configurations: Option[Map[String, String]] = None,
    dataType: Option[software.amazon.awscdk.services.iottwinmaker.CfnComponentType.DataTypeProperty] = None,
    defaultValue: Option[software.amazon.awscdk.services.iottwinmaker.CfnComponentType.DataValueProperty] = None
  ): software.amazon.awscdk.services.iottwinmaker.CfnComponentType.PropertyDefinitionProperty =
    (new software.amazon.awscdk.services.iottwinmaker.CfnComponentType.PropertyDefinitionProperty.Builder)
      .isTimeSeries(isTimeSeries.map(Boolean.box).orNull)
      .isStoredExternally(isStoredExternally.map(Boolean.box).orNull)
      .isExternalId(isExternalId.map(Boolean.box).orNull)
      .isRequiredInEntity(isRequiredInEntity.map(Boolean.box).orNull)
      .configurations(configurations.map(_.asJava).orNull)
      .dataType(dataType.orNull)
      .defaultValue(defaultValue.orNull)
      .build()
}
