package io.burkard.cdk.services.iot

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnCACertificate {

  def apply(
    internalResourceId: String,
    status: String,
    caCertificatePem: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    certificateMode: Option[String] = None,
    autoRegistrationStatus: Option[String] = None,
    verificationCertificatePem: Option[String] = None,
    registrationConfig: Option[AnyRef] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.iot.CfnCACertificate =
    software.amazon.awscdk.services.iot.CfnCACertificate.Builder
      .create(stackCtx, internalResourceId)
      .status(status)
      .caCertificatePem(caCertificatePem)
      .tags(tags.map(_.asJava).orNull)
      .certificateMode(certificateMode.orNull)
      .autoRegistrationStatus(autoRegistrationStatus.orNull)
      .verificationCertificatePem(verificationCertificatePem.orNull)
      .registrationConfig(registrationConfig.orNull)
      .build()
}
