package io.burkard.cdk.services.guardduty

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnFilter {

  def apply(
    internalResourceId: String,
    name: String,
    detectorId: String,
    description: String,
    findingCriteria: software.amazon.awscdk.services.guardduty.CfnFilter.FindingCriteriaProperty,
    rank: Number,
    action: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.guardduty.CfnFilter =
    software.amazon.awscdk.services.guardduty.CfnFilter.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .detectorId(detectorId)
      .description(description)
      .findingCriteria(findingCriteria)
      .rank(rank)
      .action(action)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
