package io.burkard.cdk.services.fsx.cfnFileSystem

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object RootVolumeConfigurationProperty {

  def apply(
    dataCompressionType: Option[String] = None,
    readOnly: Option[Boolean] = None,
    nfsExports: Option[List[_]] = None,
    copyTagsToSnapshots: Option[Boolean] = None,
    recordSizeKiB: Option[Number] = None,
    userAndGroupQuotas: Option[List[_]] = None
  ): software.amazon.awscdk.services.fsx.CfnFileSystem.RootVolumeConfigurationProperty =
    (new software.amazon.awscdk.services.fsx.CfnFileSystem.RootVolumeConfigurationProperty.Builder)
      .dataCompressionType(dataCompressionType.orNull)
      .readOnly(readOnly.map(Boolean.box).orNull)
      .nfsExports(nfsExports.map(_.asJava).orNull)
      .copyTagsToSnapshots(copyTagsToSnapshots.map(Boolean.box).orNull)
      .recordSizeKiB(recordSizeKiB.orNull)
      .userAndGroupQuotas(userAndGroupQuotas.map(_.asJava).orNull)
      .build()
}
