package io.burkard.cdk.services.evidently

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnSegment {

  def apply(
    internalResourceId: String,
    name: String,
    pattern: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    description: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.evidently.CfnSegment =
    software.amazon.awscdk.services.evidently.CfnSegment.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .pattern(pattern.orNull)
      .tags(tags.map(_.asJava).orNull)
      .description(description.orNull)
      .build()
}
