package io.burkard.cdk.services.events.targets

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SnsTopicProps {

  def apply(
    message: Option[software.amazon.awscdk.services.events.RuleTargetInput] = None,
    maxEventAge: Option[software.amazon.awscdk.Duration] = None,
    retryAttempts: Option[Number] = None,
    deadLetterQueue: Option[software.amazon.awscdk.services.sqs.IQueue] = None
  ): software.amazon.awscdk.services.events.targets.SnsTopicProps =
    (new software.amazon.awscdk.services.events.targets.SnsTopicProps.Builder)
      .message(message.orNull)
      .maxEventAge(maxEventAge.orNull)
      .retryAttempts(retryAttempts.orNull)
      .deadLetterQueue(deadLetterQueue.orNull)
      .build()
}
