package io.burkard.cdk.services.elasticsearch

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ZoneAwarenessConfig {

  def apply(
    enabled: Option[Boolean] = None,
    availabilityZoneCount: Option[Number] = None
  ): software.amazon.awscdk.services.elasticsearch.ZoneAwarenessConfig =
    (new software.amazon.awscdk.services.elasticsearch.ZoneAwarenessConfig.Builder)
      .enabled(enabled.map(Boolean.box).orNull)
      .availabilityZoneCount(availabilityZoneCount.orNull)
      .build()
}
