package io.burkard.cdk.services.eks.cfnIdentityProviderConfig

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object OidcIdentityProviderConfigProperty {

  def apply(
    clientId: String,
    issuerUrl: String,
    usernameClaim: Option[String] = None,
    requiredClaims: Option[List[_]] = None,
    usernamePrefix: Option[String] = None,
    groupsPrefix: Option[String] = None,
    groupsClaim: Option[String] = None
  ): software.amazon.awscdk.services.eks.CfnIdentityProviderConfig.OidcIdentityProviderConfigProperty =
    (new software.amazon.awscdk.services.eks.CfnIdentityProviderConfig.OidcIdentityProviderConfigProperty.Builder)
      .clientId(clientId)
      .issuerUrl(issuerUrl)
      .usernameClaim(usernameClaim.orNull)
      .requiredClaims(requiredClaims.map(_.asJava).orNull)
      .usernamePrefix(usernamePrefix.orNull)
      .groupsPrefix(groupsPrefix.orNull)
      .groupsClaim(groupsClaim.orNull)
      .build()
}
