package io.burkard.cdk.services.eks

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ServiceAccountProps {

  def apply(
    cluster: software.amazon.awscdk.services.eks.ICluster,
    name: Option[String] = None,
    annotations: Option[Map[String, String]] = None,
    labels: Option[Map[String, String]] = None,
    namespace: Option[String] = None
  ): software.amazon.awscdk.services.eks.ServiceAccountProps =
    (new software.amazon.awscdk.services.eks.ServiceAccountProps.Builder)
      .cluster(cluster)
      .name(name.orNull)
      .annotations(annotations.map(_.asJava).orNull)
      .labels(labels.map(_.asJava).orNull)
      .namespace(namespace.orNull)
      .build()
}
