package io.burkard.cdk.services.eks

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ServiceAccountOptions {

  def apply(
    annotations: Option[Map[String, String]] = None,
    name: Option[String] = None,
    labels: Option[Map[String, String]] = None,
    namespace: Option[String] = None
  ): software.amazon.awscdk.services.eks.ServiceAccountOptions =
    (new software.amazon.awscdk.services.eks.ServiceAccountOptions.Builder)
      .annotations(annotations.map(_.asJava).orNull)
      .name(name.orNull)
      .labels(labels.map(_.asJava).orNull)
      .namespace(namespace.orNull)
      .build()
}
